/**
 * 
 */
package net.sf.distrib_rsa;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;

/**
 * OutputStreamStatistics counts the bytes on a OutputStream and gives statistics
 * on the traffic sent.
 * 
 * @author lippold
 * 
 */
public class OutputStreamStatistics extends FilterOutputStream {
			
	private long byteCount = 0;
	
	private final Date startDate = new Date();

	public OutputStreamStatistics(OutputStream out) throws IOException{
		super(out);
	}
	
	public void write(final byte[] b) throws IOException{
		byteCount += b.length;
		super.write(b);
	}
	
	public void write(final byte[] b, final int off, final int len) throws IOException{
		byteCount += len;
		super.write(b, off, len);
	}
	
	public void write(final int b) throws IOException{
		byteCount++;
		super.write(b);
	}
	
	public long getByteCount(){
		return byteCount;
	}
	
	public long getRunningTime(){
		final Date finish = new Date();
		final long runtime = finish.getTime() - startDate.getTime();
		final long seconds = runtime / 1000;
		return seconds;
	}
	
	public long getBytesPerSecond(){
		return getByteCount() / getRunningTime();
	}
	
}
