package net.sf.distrib_rsa.protocols.straubSharing;

/**
 * @author lippold Published under the GPLv2 Licence (c) 2006 Georg Lippold
 * 
 */
public interface StraubProtocol {

	/**
	 * Server -> Client Client -> Server
	 * 
	 * Exchange of certificates over an unencrypted socket.
	 */
	final static int EXCHANGE_CERT = 1;

	/**
	 * Client -> Server: The client proposes a shared key size (in bits) Server ->
	 * Client: The server answers with min(proposal, own), because security for
	 * each party is determined by NCS-KeySize (pre-generated).
	 */
	final static int PREFERRED_SHARED_KEY_SIZE = 2;

	/**
	 * Client -> Server Server -> Client
	 * 
	 * The remote NaccacheStern public key
	 */
	final static int REMOTE_NCS_PUB_KEY = 3;

	/**
	 * Client -> Server Server -> Client
	 * 
	 * Synchronization point. Indicate that candidate will now be generated.
	 */
	final static int START_CANDIDATE_GENERATION = 4;

	/**
	 * Client -> Server: Ask server to generate a multiplicative sharing for the
	 * given additive sharing Server -> Client: Return the generated
	 * multiplicative sharing.
	 */
	final static int ADD_TO_MULT = 5;

	/**
	 * Client -> Server
	 * 
	 * The clients encrypted additively shared secret
	 */
	final static int REMOTE_A = 6;

	/**
	 * Server -> Client
	 * 
	 * The computed encrypted multiplicatively shared secret, generated from
	 * REMOTE_A
	 */
	final static int COMPUTED_M = 7;

	/**
	 * Client -> Server: Ask server to generate a additive sharing for the given
	 * multiplicative shared value Server -> Client: Return the generated
	 * additive sharing.
	 */
	final static int MULT_TO_ADD = 8;

	/**
	 * Client -> Server
	 * 
	 * The clients encrypted multiplicatively shared secret
	 */
	final static int REMOTE_M = 9;

	/**
	 * Client -> Server Server -> Client
	 * 
	 * The computed encrypted additively shared secret, generated from REMOTE_M
	 */
	final static int COMPUTED_A = 10;

	/**
	 * Client -> Server: Synchronization on generation Server -> Client:
	 * Synchronization successful
	 */
	final static int GEN_TABLE_SUCCESSFUL = 11;

	/**
	 * Server -> Client: Synchronization failed
	 */
	final static int TABLE_FAILED = 12;

	/**
	 * Client -> Server Server -> Client
	 * 
	 * Synchronization point. Indicate that candidate will now be verified.
	 */
	final static int START_CANDIDATE_VERIFICATION = 13;

	/**
	 * Client -> Server: Synchronization on verification Server -> Client:
	 * Synchronization successful
	 */
	final static int VER_TABLE_SUCCESSFUL = 14;

	/**
	 * Client -> Server Server -> Client
	 * 
	 * Publish MQ
	 */
	final static int PUBLISH_MQ = 15;

	/**
	 * Client -> Server Server -> Client
	 * 
	 * Conversion of (q1 * p2) to additively shared secret
	 */
	final static int CONVERT_Q1_P2 = 16;

	final static int CONVERT_Q1_P2_FINISHED = 17;

	/**
	 * Client -> Server Server -> Client
	 * 
	 * Reveal add shared secret mod 2
	 */
	final static int A_MOD_2 = 18;

	/**
	 * Client -> Server Server -> Client
	 * 
	 * Conversion of (p1 + q1)p2 to additively shared secret
	 */
	final static int CONVERT_P1_Q1_Q2 = 19;

	final static int CONVERT_P1_Q1_Q2_FINISHED = 20;

	final static int B_MOD_2 = 21;

	/**
	 * Client -> Server Server -> Client
	 * 
	 * Synchronization point for Fermat test
	 */
	final static int FERMAT_TEST = 22;

}
