/**
 * 
 */
package net.sf.distrib_rsa.ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

import javax.swing.JOptionPane;

import net.sf.distrib_rsa.EnvironmentSetup;
import net.sf.distrib_rsa.cryptosystems.PrimeUtils;
import net.sf.distrib_rsa.cryptosystems.benaloh.BenalohKeySerializer;
import net.sf.distrib_rsa.cryptosystems.benaloh.BenalohSystem;
import net.sf.distrib_rsa.cryptosystems.naccacheStern.NaccacheSternKeyGenerationParameters;
import net.sf.distrib_rsa.cryptosystems.naccacheStern.NaccacheSternKeyPairGenerator;
import net.sf.distrib_rsa.cryptosystems.naccacheStern.NaccacheSternKeyParameters;
import net.sf.distrib_rsa.cryptosystems.naccacheStern.NaccacheSternKeySerializationFactory;
import net.sf.distrib_rsa.cryptosystems.naccacheStern.NaccacheSternPrivateKeyParameters;

import org.apache.log4j.Logger;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.util.encoders.Base64;


/**
 * @author lippold
 * 
 */
public class KeyGenerationParameters {

	private static final Logger log = Logger
			.getLogger(KeyGenerationParameters.class);

	public static void getKeySize(final Properties prop) {
		String keySize = null;
		while ((keySize == null) || "".equals(keySize)) {
			keySize = (String) JOptionPane.showInputDialog(StandardDialogs
					.getAppFrame(),
					"Please the size (in Bits) of the shared RSA key\n"
							+ "that will be generated with this software",
					"Input key size", JOptionPane.QUESTION_MESSAGE, null, null,
					"1024");
			try {
				final int i = Integer.parseInt(keySize);
				if (i > 0) {
					break;
				}
			} catch (final Exception e) {

			}
		}
		prop.setProperty(EnvironmentSetup.KEY_SIZE, keySize);

	}

	public static void getPrimeCertainty(final Properties prop) {
		final String primeCert = (String) JOptionPane.showInputDialog(
				StandardDialogs.getAppFrame(),
				"Please input an Integer x for the following\n" + "equation:\n"
						+ "1-(1/2)^x\n" + "The result is the certainty that\n"
						+ "primes used in this program \n"
						+ "are really prime.", "Input prime certainty",
				JOptionPane.QUESTION_MESSAGE, null, null, "30");
		prop.setProperty(EnvironmentSetup.PRIME_CERTAINTY, primeCert);
	}

	public static void generateNCSKeyPair(final Properties prop)
			throws NoSuchAlgorithmException, NoSuchProviderException,
			IOException {
		final String msg = "To use this software, you need a NaccacheStern KeyPair.\n"
				+ "Do you want to create a NaccacheStern KeyPair\n"
				+ "on the fly or load it from files?";
		final String[] buttons = { "Create", "Load" };
		final int res = StandardDialogs.customDialogBox(msg,
				"NaccacheStern KeyPair needed", buttons);
		if (res == 0) {
			log.debug("creating new NaccacheSternKeyGenerationParameters("
					+ EnvironmentSetup.getSecureRandom() + ","
					+ EnvironmentSetup.getDesiredKeySize() + ", "
					+ EnvironmentSetup.getPrimeCertainty() + ", "
					+ EnvironmentSetup.getDesiredKeySize() / 25 + ")");
			final NaccacheSternKeyGenerationParameters parameters = new NaccacheSternKeyGenerationParameters(
					EnvironmentSetup.getSecureRandom(), EnvironmentSetup
							.getDesiredKeySize(), EnvironmentSetup
							.getPrimeCertainty(), EnvironmentSetup
							.getDesiredKeySize() / 25);
			final NaccacheSternKeyPairGenerator generator = new NaccacheSternKeyPairGenerator(
					Runtime.getRuntime().availableProcessors());
			generator.init(parameters);

			StandardDialogs
					.showWaitDialog("Please wait while the NaccacheStern KeyPair is generated");
			final AsymmetricCipherKeyPair pair = generator.generateKeyPair();
			final NaccacheSternKeyParameters pub = (NaccacheSternKeyParameters) pair
					.getPublic();
			final NaccacheSternPrivateKeyParameters priv = (NaccacheSternPrivateKeyParameters) pair
					.getPrivate();
			final byte[] pubSerialized = NaccacheSternKeySerializationFactory
					.getSerialized(pub);
			final byte[] privSerialized = NaccacheSternKeySerializationFactory
					.getSerialized(priv);
			prop.setProperty(EnvironmentSetup.NCS_PUB_KEY, new String(Base64
					.encode(pubSerialized)));
			prop.setProperty(EnvironmentSetup.NCS_PRIV_KEY, new String(Base64
					.encode(privSerialized)));
			StandardDialogs.hideWaitDialog();
		} else {
			final String[] endings = { "txt", "properties" };
			final File pubFile = StandardDialogs.openFileDialog(endings,
					"Select public key file",
					"serialized NaccacheSternPublicKey");
			BufferedReader br = new BufferedReader(new InputStreamReader(
					new FileInputStream(pubFile)));
			String keyStr = br.readLine();
			prop.setProperty(EnvironmentSetup.NCS_PUB_KEY, keyStr);
			final File privFile = StandardDialogs.openFileDialog(endings,
					"Select private key file",
					"serialized NaccacheSternPrivateKey");
			br = new BufferedReader(new InputStreamReader(new FileInputStream(
					privFile)));
			keyStr = br.readLine();
			prop.setProperty(EnvironmentSetup.NCS_PRIV_KEY, keyStr);
		}
	}

	public static void generateBenalohSystems(final Properties prop)
			throws NoSuchAlgorithmException, NoSuchProviderException,
			IOException {

		final Hashtable benalohSystems = new Hashtable();

		final int preferredSharedKeySize = EnvironmentSetup.getDesiredKeySize();
		final int[] minPrimes = PrimeUtils.getFirstPrimes(preferredSharedKeySize);

		int primeCnt = 0;
		BigInteger genProd = BigInteger.ONE;
		final Object o = new Object();

		// genProd is the minimal set of the smallest
		// primes, so that P exceeds 2^(l-1)/2. (l is bitlength of the shared
		// key)
		BigInteger prime;
		int p;
		while (genProd.bitLength() < preferredSharedKeySize / 2) {
			p = minPrimes[primeCnt];
			prime = BigInteger.valueOf(p);
			genProd = genProd.multiply(prime);
			benalohSystems.put(prime, o);
			primeCnt++;
		}
		
		final int finalBitLength = genProd.bitLength() * 2;
		
		while (genProd.bitLength() < finalBitLength) {
			prime = BigInteger.valueOf(minPrimes[primeCnt]);
			genProd = genProd.multiply(prime);
			benalohSystems.put(prime, o);
			primeCnt++;
		}

		// Put in an additional system since 2 and 3 are not used
		benalohSystems.put(BigInteger.valueOf(minPrimes[primeCnt]), o);
		
		log.debug("P has " + benalohSystems.size()
				+ " primes, the largest prime is " + minPrimes[primeCnt - 1]
				+ " the product of all Primes is " + genProd + " with "
				+ genProd.bitLength() + " bit.");

		String msg = "To use this software with your \n"
				+ "desired key size of "
				+ preferredSharedKeySize
				+ " bit, \n"
				+ "you need "
				+ benalohSystems.size()
				+ " Benaloh KeyPairs.\n\n"
				+ "They will be generated now. You can re-use them if you save your settings.";
		// "Do you want to create them on the fly\n" +
		// "or load them from a file?";
		final String[] buttons = { "OK" };
		final int res = StandardDialogs.customDialogBox(msg,
				"Benaloh KeyPairs needed", buttons);
		if (res == 0) {
			final Enumeration en = benalohSystems.keys();
			int i = 1;
			while (en.hasMoreElements()) {
				prime = (BigInteger) en.nextElement();
				msg = "Generating Benaloh System for prime " + prime + "\n"
						+ "(" + i + "/" + benalohSystems.size() + ")";
				// log.debug(msg);
				StandardDialogs.showWaitDialog(msg);
				final BenalohSystem bs = new BenalohSystem(preferredSharedKeySize,
						prime);
				benalohSystems.put(prime, bs);
				final byte[] privSerialized = BenalohKeySerializer.getSerialized(bs
						.getPriv());
				prop.setProperty(EnvironmentSetup.BENALOH_SYSTEM
						+ bs.getPrime(), new String(Base64
						.encode(privSerialized)));
				i++;
				StandardDialogs.hideWaitDialog();
			}

		}
	}

}
