/**
 * 
 */
package net.sf.distrib_rsa.ui;

import java.util.Properties;

import javax.swing.JOptionPane;

import net.sf.distrib_rsa.EnvironmentSetup;


/**
 * @author lippold
 * 
 */
public class NetSetupUI {

	public static void getOperationMode(final Properties properties) {
		final String buttons[] = new String[2];
		buttons[0] = "Connect to server";
		buttons[1] = "Act as server";
		final int res = StandardDialogs.customDialogBox(
				"Do you want to set up this host\n"
						+ "as a client that connects to a server\n"
						+ "or as a server that listens for connections?\n",
				"Select operating mode", buttons);
		if (res == 0) {
			properties.setProperty(EnvironmentSetup.SERVER_MODE, "false");
			getServerName(properties);
			getPort(properties);
		} else {
			properties.setProperty(EnvironmentSetup.SERVER_MODE, "true");
			getPort(properties);
		}
	}

	private static void getPort(final Properties prop) {
		final String port = (String) JOptionPane.showInputDialog(
				StandardDialogs.getAppFrame(),
				"Please input the port the server listens on", "Input port",
				JOptionPane.QUESTION_MESSAGE, null, null, "4444");
		prop.setProperty(EnvironmentSetup.PORT, port);
	}

	private static void getServerName(final Properties prop) {
		final String address = (String) JOptionPane.showInputDialog(
				StandardDialogs.getAppFrame(),
				"Please input the server address", "Input server address",
				JOptionPane.QUESTION_MESSAGE, null, null, "localhost");
		prop.setProperty(EnvironmentSetup.SERVER_ADDRESS, address);
	}

	public static void getPreferredProtocol(final Properties prop) {
		final String message = "Please select key sharing protocol";
		final String choice = (String) JOptionPane.showInputDialog(StandardDialogs
				.getAppFrame(), message, "Select protocol",
				JOptionPane.QUESTION_MESSAGE, null, EnvironmentSetup.PROTOCOLS,
				null);
		prop.setProperty(EnvironmentSetup.PROTOCOL, choice);
	}
}
