package net.sf.distrib_rsa.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;

/**
 * @author lippold Published under the GPLv2 Licence (c) 2006 Georg Lippold
 * 
 */
class NotifyButton extends JButton {

	private static final long serialVersionUID = -8066085856635663092L;

	/**
	 * @uml.property  name="pressed"
	 */
	private boolean pressed = false;

	/**
	 * @uml.property  name="waitFor"
	 */
	private final Object waitFor;

	NotifyButton(final String label, final Object waitFor) {
		super(label);
		this.waitFor = waitFor;
		init();
	}

	private void init() {
		addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {
				synchronized (waitFor) {
					pressed = true;
					waitFor.notifyAll();
				}
			}
		});
	}

	public boolean isPressed() {
		return pressed;
	}
}
