/**
 * 
 */
package net.sf.distrib_rsa.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ScrollPaneConstants;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

import org.apache.log4j.Logger;

/**
 * @author lippold
 * 
 */
public class StandardDialogs {

	private static final Logger log = Logger.getLogger(StandardDialogs.class);

	public static JFrame defaultFrame = null;

	private static WaitDialog wd = null;

	public static void disposeUI() {
		if (defaultFrame != null) {
			defaultFrame.dispose();
		}
	}

	protected static JFrame getAppFrame() {
		return defaultFrame;
	}

	protected static void showWaitDialog(final String txt) {
		if (wd == null) {
			wd = new WaitDialog(defaultFrame, "Please Wait...", "clock.png");
		}
		wd.setText(txt);
		wd.showDialog();
	}

	protected static void hideWaitDialog() {
		wd.hideDialog();
	}

	protected static File openFileDialog(final String[] fileEndings,
			final String title, final String description) {
		final JFileChooser jfc = new JFileChooser();
		final FileFilter filter = new FileFilter() {
			public boolean accept(File f) {
				if (f.isDirectory()) {
					return true;
				}
				final String fn = f.getName().toLowerCase();
				for (int i = 0; i < fileEndings.length; i++) {
					if (fn.endsWith(fileEndings[i])) {
						return true;
					}
				}
				return false;
			}

			public String getDescription() {
				return description;
			}
		};
		jfc.setFileFilter(filter);
		jfc.setDialogTitle(title);
		final int retval = jfc.showOpenDialog(StandardDialogs.getAppFrame());
		if (retval == JFileChooser.APPROVE_OPTION) {
			return jfc.getSelectedFile();
		}
		return null;
	}

	protected static File saveFileDialog(final String[] fileEndings,
			final String title, final String description) {
		final JFileChooser jfc = new JFileChooser();
		final FileFilter filter = new FileFilter() {
			public boolean accept(File f) {
				if (f.isDirectory()) {
					return true;
				}
				final String fn = f.getName();
				for (int i = 0; i < fileEndings.length; i++) {
					if (fn.endsWith(fileEndings[i])) {
						return true;
					}
				}
				return false;
			}

			public String getDescription() {
				return description;
			}
		};
		jfc.setFileFilter(filter);
		jfc.setDialogTitle(title);
		final int retval = jfc.showSaveDialog(StandardDialogs.getAppFrame());
		if (retval == JFileChooser.APPROVE_OPTION) {
			File file = jfc.getSelectedFile();
			final String filename = file.getName().toLowerCase();
			boolean correctEnding = false;
			for (int i = 0; i < fileEndings.length; i++) {
				if (filename.endsWith(fileEndings[i])) {
					correctEnding = true;
					break;
				}
			}
			if (correctEnding) {
				return file;
			} else {
				file = new File(file.getAbsolutePath() + "." + fileEndings[0]);
				return file;
			}
		}
		return null;
	}

	protected static int customDialogBox(final String message, final String title,
			final Object[] options) {
		return JOptionPane.showOptionDialog(StandardDialogs.getAppFrame(),
				message, title, JOptionPane.YES_NO_OPTION,
				JOptionPane.QUESTION_MESSAGE, null, options, options[0]);
	}

	protected static void warningBox(final String message) {
		final Object options[] = { "OK" };
		log.warn(message);
		JOptionPane.showOptionDialog(StandardDialogs.getAppFrame(), message,
				"WarningBox", JOptionPane.DEFAULT_OPTION,
				JOptionPane.WARNING_MESSAGE, null, options, options[0]);

	}

	protected static char[] passwordBox(final String message, final String title) {
		final JDialog jd = new JDialog(StandardDialogs.getAppFrame());

		final JPanel jp = new JPanel();
		final GridBagLayout gb = new GridBagLayout();
		final GridBagConstraints gbc = new GridBagConstraints();
		jp.setLayout(gb);

		final JLabel jl = new JLabel(message);
		gbc.fill = GridBagConstraints.BOTH;
		gbc.weightx = 0.0;
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		gb.setConstraints(jl, gbc);
		jp.add(jl);

		final JPasswordField jpf = new JPasswordField();
		jpf.setColumns(20);
		gbc.fill = GridBagConstraints.BOTH;
		gbc.weightx = 0.0;
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		jpf.setText("");
		gb.setConstraints(jl, gbc);
		jp.add(jpf);

		final JButton ok = new JButton("OK");
		gbc.weightx = 0.0;
		gbc.weighty = 0.0;
		gbc.weightx = GridBagConstraints.REMAINDER;
		gbc.fill = GridBagConstraints.NONE;
		gb.setConstraints(ok, gbc);
		jp.add(ok);

		jd.getContentPane().add(jp);
		jd.setTitle(title);
		jd.pack();
		final Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
		jd.setLocation((d.width - jd.getWidth()) / 2, (d.height - jd
				.getHeight()) / 2);

		jd.setVisible(true);
		final Object lockOn = new Object();
		ok.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {
				synchronized (lockOn) {
					lockOn.notifyAll();
				}
			}
		});
		final Action enterListener = new AbstractAction() {
			private static final long serialVersionUID = -1304743612309745604L;

			public void actionPerformed(ActionEvent e) {
				synchronized (lockOn) {
					lockOn.notifyAll();
				}
			}
		};

		jpf.getInputMap().put(KeyStroke.getKeyStroke('\n'), "ok");
		jpf.getActionMap().put("ok", enterListener);
		synchronized (lockOn) {
			try {
				lockOn.wait();
			} catch (final InterruptedException e1) {
				e1.printStackTrace();
			}
		}
		jd.dispose();
		return jpf.getPassword();
	}

	protected static void handleException(final Exception e) {
		warningBox("An exception occured loading your keystore:\n"
				+ e.toString() + "\n" + e.getCause());
		// + "\n\nIf you feel this is not your fault, please submit a"
		// + " bug in the Bugs section at http://peeranha42.sf.net\nExiting.");
		// System.exit(1);
	}

	protected static int showHTMLDialog(final String title, final String message,
			final Object[] buttons) {
		final JDialog jd = new JDialog(StandardDialogs.getAppFrame());
		final BorderLayout bl = new BorderLayout();
		jd.getContentPane().setLayout(bl);
		jd.setTitle(title);
		final JEditorPane jep = new JEditorPane();
		jep.setAutoscrolls(true);
		jep.setContentType("text/html");
		jep.setText(message);
		jep.setEditable(false);
		jep.addHyperlinkListener(new HyperlinkListener() {
			public void hyperlinkUpdate(final HyperlinkEvent e) {
				if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
					final JEditorPane pane = (JEditorPane) e.getSource();
					if (e instanceof HTMLFrameHyperlinkEvent) {
						final HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent) e;
						final HTMLDocument doc = (HTMLDocument) pane.getDocument();
						doc.processHTMLFrameHyperlinkEvent(evt);
					} else {
						try {
							pane.setPage(e.getURL());
						} catch (final Throwable t) {
							log
									.fatal(
											"Caught Exception while trying to set page: ",
											t);
						}
					}
				}
			}
		});
		final JScrollPane editorScrollPane = new JScrollPane(jep);
		final Dimension d = Toolkit.getDefaultToolkit().getScreenSize();

		editorScrollPane.setPreferredSize(new Dimension(d.width / 2,
				d.height / 2 - 70));
		editorScrollPane.setMinimumSize(new Dimension(10, 10));
		editorScrollPane
				.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
		editorScrollPane
				.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);
		final JPanel jp = new JPanel();
		jp.add(editorScrollPane);
		jd.getContentPane().add(jp, BorderLayout.CENTER);

		final Object waitFor = new Object();
		final JPanel buttonPanel = new JPanel(new GridLayout(1, buttons.length));
		final NotifyButton[] buttonArray = new NotifyButton[buttons.length];
		synchronized (waitFor) {
			for (int i = 0; i < buttons.length; i++) {
				final NotifyButton button = new NotifyButton(buttons[i].toString(),
						waitFor);
				buttonPanel.add(button);
				buttonArray[i] = button;
			}
			jd.getContentPane().add(buttonPanel, BorderLayout.SOUTH);
			jd.pack();
			jd.setLocation(d.width / 4, d.height / 4);
			jd.setResizable(true);
			jd.setVisible(true);
			try {
				waitFor.wait();
			} catch (final InterruptedException e1) {
				log.fatal("got interrupted while waiting for user choice", e1);
			}
		}
		int retval = -1;
		for (int i = 0; i < buttonArray.length; i++) {
			if (buttonArray[i].isPressed()) {
				retval = i;
				break;
			}
		}
		jd.dispose();
		return retval;
	}

	// protected static void handleNoProviderException(){
	// String title = "Bouncycastle Provider not registered";
	// String msg = "<HTML>\n"
	// + "<BODY>\n"
	// + "<h1>BouncyCastle Provider not registered with JDK</h1>\n"
	// + "<p>The BouncyCastle Provider used by this software is not" +
	// "registered with your JDK. Please visit</p>"
	// + "<p><a href="
	// ;
	// }

	protected static void handleSecException() {
		final String title = "JDK encryption not sufficient";
		final String msg = "<HTML>\n"
				+ "<BODY>"
				+ "The encryption of your JRE is not sufficient.<br>"
				+ "You can download the required components from<br>"
				+ "<a href=\"http://javashoplm.sun.com/ECom/docs/Welcome.jsp?StoreId=22&PartDetailId=7503-jce-1.4.2-oth-JPR&SiteId=JSC&TransactionId=noreg\">"
				+ "Sun for JRE 1.4.2</a><br>Link: <br><br>"
				+ "http://javashoplm.sun.com/ECom/docs/Welcome.jsp?StoreId=22&PartDetailId=7503-jce-1.4.2-oth-JPR&SiteId=JSC&TransactionId=noreg <br>"
				+ "<br> or<br>"
				+ "<a href=\"http://javashoplm.sun.com/ECom/docs/Welcome.jsp?StoreId=22&PartDetailId=jce_policy-1.5.0-oth-JPR&SiteId=JSC&TransactionId=noreg\">"
				+ "Sun for JRE 1.5.0</a><br>Link: <br><br>"
				+ "http://javashoplm.sun.com/ECom/docs/Welcome.jsp?StoreId=22&PartDetailId=jce_policy-1.5.0-oth-JPR&SiteId=JSC&TransactionId=noreg <br>"
				+ "<br> Support for other JRE's from Sun can be obtained by visiting<br>"
				+ "<a href=\"http://java.sun.com\">Sun's Java Pages</a><br> Link: <br><br>"
				+ "http://java.sun.com/<br><br>"
				+ "and downloading the <br>"
				+ "\"Unlimited Strength Jurisdiction Files\" from the download section of your JRE.<br><br>"
				+ "You can only start this application after installing these files."
				+ "</BODY>" + "</HTML>";
		final String[] buttons = { "OK" };
		showHTMLDialog(title, msg, buttons);
		System.exit(1);
	}

}
