package net.sf.distrib_rsa.cryptosystems.benaloh;

import java.math.BigInteger;
import java.security.SecureRandom;

import org.bouncycastle.crypto.KeyGenerationParameters;

/**
 * @author lippold Published under the GPLv2 Licence (c) 2006 Georg Lippold
 * 
 */
public class BenalohKeyGenerationParameters extends KeyGenerationParameters {
	/**
	 * the certainty that p and q in the BenalohParameters are really prime. cert = 1- (1/2)^primeCertainty.
	 * @uml.property  name="primeCertainty"
	 */
	private final int primeCertainty;

	/**
	 * The BigInteger r that makes up the message space.
	 * @uml.property  name="r"
	 */
	private final BigInteger r;

	/**
	 * Constructs a new BenalohParameters
	 * 
	 * (see J. Benaloh: Dense Probabilisic Encryption, online at
	 * 
	 * http://research.microsoft.com/crypto/papers/dpe.ps )
	 * 
	 * @param random
	 *            The source of Randomness to use.
	 * @param strength
	 *            The strength of the Benaloh encryption system in bit.
	 * @param r
	 *            The upper limit for the message space.
	 * @param primeCertainty
	 *            the certainty for generated primes.
	 */
	public BenalohKeyGenerationParameters(final SecureRandom random,
			final int strength, final BigInteger r, final int primeCertainty) {
		super(random, strength);
		this.r = r;
		this.primeCertainty = primeCertainty;
	}

	/**
	 * The PrimeCertainty
	 * @return  the desired primeCertainty.
	 * @uml.property  name="primeCertainty"
	 */
	public int getPrimeCertainty() {
		return primeCertainty;
	}

	/**
	 * The r
	 * @return  The desired size of the message space.
	 * @uml.property  name="r"
	 */
	public BigInteger getR() {
		return r;
	}

}
