package net.sf.distrib_rsa.protocols.straubSharing;

import java.math.BigInteger;

/**
 * @author lippold Published under the GPLv2 Licence (c) 2006 Georg Lippold
 * 
 */
public class AddMultRemainders {

	/**
	 * @uml.property  name="additive"
	 */
	private final BigInteger additive;

	/**
	 * @uml.property  name="multiplicative"
	 */
	private final BigInteger multiplicative;

	/**
	 * @uml.property  name="sigma"
	 */
	private final BigInteger sigma;

	protected AddMultRemainders(final BigInteger additive, final BigInteger multiplicative,
			final BigInteger sigma) {
		this.additive = additive;
		this.multiplicative = multiplicative;
		this.sigma = sigma;
	}

	/**
	 * @return  the additive
	 * @uml.property  name="additive"
	 */
	public BigInteger getAdditive() {
		return additive;
	}

	/**
	 * @return  the multiplicative
	 * @uml.property  name="multiplicative"
	 */
	public BigInteger getMultiplicative() {
		return multiplicative;
	}

	public BigInteger getAdditiveInverse() {
		return additive.negate().mod(sigma);
	}

	public BigInteger getMultiplicativeInverse() {
		return multiplicative.modInverse(sigma);
	}

	public String toString() {
		String ret = "";
		ret += "Additively shared: ......" + additive + "\n";
		ret += "Multiplicatively shared: " + multiplicative + "\n";
		return ret;
	}
}
