/*
 * Created on May 19, 2005
 *
 */
package net.sf.distrib_rsa.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.net.URL;

import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;

/**
 * This class is used to display the Wait Dialog.
 */
class WaitDialog extends JDialog {
	private static final long serialVersionUID = 4300627261936967181L;

	/**
	 * @uml.property  name="image"
	 * @uml.associationEnd  multiplicity="(1 1)"
	 */
	private JLabel image = new JLabel();

	/**
	 * @uml.property  name="text"
	 * @uml.associationEnd  
	 */
	private JLabel text;

	protected WaitDialog(final JFrame parent, final String title, final String image) {
		super(parent);
		super.setTitle(title);

		final URL imgURL = getClass().getResource(image);
		if (imgURL != null) {
			final ImageIcon img = new ImageIcon(imgURL);
			if (img != null) {
				this.image = new JLabel(img);
			}
		}

		super.getContentPane().setLayout(new BorderLayout());
		super.getContentPane().add(this.image, BorderLayout.WEST);
	}

	public void setText(final String txt) {
		if (text != null) {
			super.getContentPane().remove(text);
		}
		String htmlTxt = "<html><p align=center>\n";
		final String[] txtParts = txt.split("\n");
		for (int i = 0; i < txtParts.length; i++) {
			htmlTxt = htmlTxt + txtParts[i];
			htmlTxt = htmlTxt + "<br>\n";
		}
		htmlTxt = htmlTxt + "</p></html>";
		text = new JLabel(htmlTxt);
		text.setForeground(SystemColor.textText);
		text.setFont(new Font("Dialog", 1, 13));
		super.getContentPane().add(text, BorderLayout.CENTER);
		super.pack();
		final Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
		super.setLocation((d.width - super.getWidth()) / 2, (d.height - super
				.getHeight()) / 2);
	}

	public void showDialog() {
		super.setVisible(true);
	}

	public void hideDialog() {
		super.setVisible(false);
	}
}
