package Algorithm;

import java.util.ArrayList;
import java.util.List;


public class ExtendedString {

	private String sequence;
	private String extendedSequence;
	private int q;
	private int s;
	
	private List<PosQGram> qgrams = new ArrayList<PosQGram>();
	
	/**
	 * @param sequence represents the string that will be split into q-grams
	 * @param q sets the length of the substrings to be generated
	 * @param s defines how much shift to be considered for each q-gram 
	 */
	public ExtendedString(String sequence, int q, int s) {
		this.q = q;
		this.s = s;
		
		int i=0;
		this.sequence = sequence;
		this.extendedSequence = "";
		
		for(i=0; i<(q-1); i++) {
			this.extendedSequence += "_";
		}
		
		this.extendedSequence += this.sequence;
		
		for(i=0; i<(q-1); i++) {
			this.extendedSequence += "_";
		}
	}
	
	public void generatePosQGrams() {
		int i=0,j=0;
		
		int numSubstrings = this.extendedSequence.length()-(this.q-1);
		
		for(j=0; j<numSubstrings; j++) {
			for(i=-s; i<=s; i++) {
				qgrams.add(new PosQGram(i+j, this.extendedSequence.substring(j, j+this.q)));
			}
		}
	}
	
	public String getExtendedSeq() {
		return this.extendedSequence;
	}
	
	public void printAllQGrams(String prefix) {
		int i=0;
		String emptyPrefix="";
		
		for(i=0; i<prefix.length() + 3; i++) {
			emptyPrefix += " ";
		}
		
		
		i=0;
		
		System.out.print(prefix + " = ");
		for(PosQGram pq : this.qgrams) {
			if(i>0 && (i%10)==0) {
				System.out.println();
				System.out.print(emptyPrefix);
			}
			System.out.print(pq.getString() + "  ");
			i++;
		}
		System.out.println();
	}
	
	public int getNumPosQGrams() {
		return this.qgrams.size();
	}
	
	public List<PosQGram> getPosQGrams() {
		return this.qgrams;
	}
	
}
