package Crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import java.util.Vector;

import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.InvalidCipherTextException;

import net.sf.distrib_rsa.cryptosystems.naccacheStern.NaccacheSternEngine;
import net.sf.distrib_rsa.cryptosystems.naccacheStern.NaccacheSternKeyGenerationParameters;
import net.sf.distrib_rsa.cryptosystems.naccacheStern.NaccacheSternKeyPairGenerator;
import net.sf.distrib_rsa.cryptosystems.naccacheStern.NaccacheSternKeyParameters;
import net.sf.distrib_rsa.cryptosystems.naccacheStern.NaccacheSternKeySerializationFactory;
import net.sf.distrib_rsa.cryptosystems.naccacheStern.NaccacheSternPrivateKeyParameters;

import Algorithm.BloomEncryption;
import Helper.FileByteA;
import Helper.Timer;
import Helper.UnitConversion;

/**
 * Test case for NaccacheStern cipher. For details on this cipher, please see
 * 
 * http://www.gemplus.com/smart/rd/publications/pdf/NS98pkcs.pdf
 *
 * Performs the following tests: 
 *  <ul>
 *  <li> Toy example from the NaccacheSternPaper </li>
 *  <li> 768 bit test with text "Now is the time for all good men." (ripped from RSA test) and
 *     the same test with the first byte replaced by 0xFF </li>
 *  <li> 1024 bit test analog to 768 bit test </li>
 *  </ul>
 */
public class CryptClientNS
{
//    static final boolean debug = false;

    static final NaccacheSternEngine cryptEng = new NaccacheSternEngine(4);

    static final NaccacheSternEngine decryptEng = new NaccacheSternEngine(4);

    static final Random rnd = new RandomSource(BloomEncryption.secureRandom).getRandom();
    
//    static
//    {
//        cryptEng.setDebug(debug);
//        decryptEng.setDebug(debug);
//    }

    // Values from NaccacheStern paper
//    static BigInteger a;

//    static final BigInteger u1 = BigInteger.valueOf(3);
//
//    static final BigInteger u2 = BigInteger.valueOf(5);
//
//    static final BigInteger u3 = BigInteger.valueOf(7);

//    static final BigInteger u1 = BigInteger.valueOf(37);
//    
//    static BigInteger b;

//    static final BigInteger v1 = BigInteger.valueOf(11);
//
//    static final BigInteger v2 = BigInteger.valueOf(13);
//
//    static final BigInteger v3 = BigInteger.valueOf(17);

//    static final BigInteger v1 = BigInteger.valueOf(47);
    
    static final BigInteger ONE = BigInteger.valueOf(1);

    static final BigInteger TWO = BigInteger.valueOf(2);

//    static final BigInteger sigma = u1.multiply(u2).multiply(u3).multiply(v1)
//            .multiply(v2).multiply(v3);
//
//    static final BigInteger p = TWO.multiply(a).multiply(u1).multiply(u2)
//            .multiply(u3).add(ONE);
//
//    static final BigInteger q = TWO.multiply(b).multiply(v1).multiply(v2)
//            .multiply(v3).add(ONE);

//    static BigInteger sigma;
//
//    static BigInteger p;
//
//    static BigInteger q;
//
//    static BigInteger n;
//
//    static BigInteger phi_n;
//
//    static BigInteger g;
//
//    static Vector<BigInteger> smallPrimesA = new Vector<BigInteger>();
//    static Vector<BigInteger> smallPrimesB = new Vector<BigInteger>();
//    static Vector<BigInteger> smallPrimes = new Vector<BigInteger>();
    
    static final int bitLength = 1248; 
    
    static final boolean writeReadKeyPairOnDisk = true;
    static final String keyFilePrefix = "NaccSt";

//    // static final BigInteger paperTest = BigInteger.valueOf(202);
//
//    static final String input = "4e6f77206973207468652074696d6520666f7220616c6c20676f6f64206d656e";
//
//    static final BigInteger paperTest = BigInteger.valueOf(202);
//
//    //
//    // to check that we handling byte extension by big number correctly.
//    //
//    static final String edgeInput = "ff6f77206973207468652074696d6520666f7220616c6c20676f6f64206d656e";

    private NaccacheSternKeyParameters pubParameters = null;
    private NaccacheSternPrivateKeyParameters privParameters = null;
    
    private AsymmetricCipherKeyPair pair = null;
    
    public String getName()
    {
        return "NaccacheStern";
    }
    
    public void init()
    {
    	System.out.println("Set client crypto seed");
    	rnd.setSeed(RandomSource.getNextSeed(BloomEncryption.secureRandom));
        // Test with given key from NaccacheSternPaper (totally insecure)

        NaccacheSternKeyGenerationParameters genParam;
        NaccacheSternKeyPairGenerator pGen;
        // First the Parameters from the NaccacheStern Paper
        // (see http://www.gemplus.com/smart/rd/publications/pdf/NS98pkcs.pdf )

//    	a = BigInteger.valueOf(101);
//    	a = new BigInteger(bitLength-1, rnd);
//    	b = BigInteger.valueOf(191);
//    	b = new BigInteger(bitLength-1, rnd);
    	
//        smallPrimes.addElement(u1);
//        smallPrimes.addElement(u2);
//        smallPrimes.addElement(u3);
//        smallPrimes.addElement(v1);
//        smallPrimes.addElement(v2);
//        smallPrimes.addElement(v3);
//        smallPrimesA.addElement(u1);
//        smallPrimesB.addElement(v1);
//
//        smallPrimes.addAll(smallPrimesA);
//        smallPrimes.addAll(smallPrimesB);
//        
//        sigma = ONE;
//        for(BigInteger smallPrime : smallPrimes) {
//        	sigma = sigma.multiply(smallPrime);
//        }
//        
//        p = TWO.multiply(a);
//        for(BigInteger smallPrimeA : smallPrimesA) {
//        	 p = p.multiply(smallPrimeA);
//        }
//        p.add(ONE);
//        
//        q = TWO.multiply(b);
//        for(BigInteger smallPrimeB : smallPrimesB) {
//        	 q = q.multiply(smallPrimeB);
//        }
//        q.add(ONE);
//
//        n = p.multiply(q);
//        
//        phi_n = p.subtract(ONE).multiply(q.subtract(ONE));
//        
//        g = BigInteger.valueOf(131);

//        pubParameters = new NaccacheSternKeyParameters(false, g, n, sigma.bitLength());
//
//        initClient.setIntermediate();
//        
//        NaccacheSternPrivateKeyParameters privParameters = new NaccacheSternPrivateKeyParameters(g, n, sigma.bitLength(), smallPrimes, phi_n);
//
//        initClient.setIntermediate();
//
//        AsymmetricCipherKeyPair pair = new AsymmetricCipherKeyPair(pubParameters, privParameters);
//
//        initClient.setIntermediate();

//        // Initialize Engines with KeyPair
//
//        if (debug)
//        {
//            System.out.println("initializing encryption engine");
//        }
//        cryptEng.init(true, pair.getPublic());
//
//        if (debug)
//        {
//            System.out.println("initializing decryption engine");
//        }
//        decryptEng.init(false, pair.getPrivate());

        // specify key generation parameters
//        NaccacheSternKeyGenerationParameters genParam = new NaccacheSternKeyGenerationParameters(new SecureRandom(), 768, 8, 30, debug);
//    	System.out.println("Set parameters for keygen");
        
        if(BloomEncryption.pubParameters != null && BloomEncryption.privParameters != null) {
        	pubParameters = BloomEncryption.pubParameters;
        	privParameters = BloomEncryption.privParameters;
        	pair = new AsymmetricCipherKeyPair(pubParameters, privParameters);
        } else {
	        
	        if(writeReadKeyPairOnDisk) {
	        	File fPub = new File(keyFilePrefix + this.bitLength + "Bit" + "Pub" + ".key");
	        	File fPriv = new File(keyFilePrefix + this.bitLength + "Bit" + "Priv" + ".key");
	        	if(fPub.exists() && fPriv.exists()) {
	        		System.out.println("Found key files, reading from disk.");
					try {
						pubParameters = NaccacheSternKeySerializationFactory.deserialize(FileByteA.getByteAFromFile(fPub));
						privParameters = (NaccacheSternPrivateKeyParameters) NaccacheSternKeySerializationFactory.deserialize(FileByteA.getByteAFromFile(fPriv));
						
						BloomEncryption.pubParameters = pubParameters;
						BloomEncryption.privParameters = privParameters;
					} catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					} catch (ClassNotFoundException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
					
					pair = new AsymmetricCipherKeyPair(pubParameters, privParameters);
	        	} else {
	        		System.out.println("Key files not found, writing to disk.");
	                genParam = new NaccacheSternKeyGenerationParameters(new SecureRandom(), this.bitLength, 2, 30, false);
	
	                // Initialize Key generator and generate key pair
	//            	System.out.println("Init keygen");
	                pGen = new NaccacheSternKeyPairGenerator();
	                pGen.init(genParam);
	        		pair = pGen.generateKeyPair();
	        		try {
						FileByteA.writeByteAIntoFile(fPub, NaccacheSternKeySerializationFactory.getSerialized((NaccacheSternKeyParameters) pair.getPublic()));
						FileByteA.writeByteAIntoFile(fPriv, NaccacheSternKeySerializationFactory.getSerialized((NaccacheSternKeyParameters) pair.getPrivate()));
					} catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
	        		
	                pubParameters = (NaccacheSternKeyParameters) pair.getPublic();
	                privParameters = (NaccacheSternPrivateKeyParameters) pair.getPrivate();
	        		
					BloomEncryption.pubParameters = pubParameters;
					BloomEncryption.privParameters = privParameters;
	        	}
	        } else {
	        	System.out.println("Not using disk cache for keys");
	            genParam = new NaccacheSternKeyGenerationParameters(new SecureRandom(), this.bitLength, 2, 30, false);
	
	            // Initialize Key generator and generate key pair
	//        	System.out.println("Init keygen");
	            pGen = new NaccacheSternKeyPairGenerator();
	            pGen.init(genParam);
	            pair = pGen.generateKeyPair();
	        }
        }
        if (((NaccacheSternKeyParameters)pair.getPublic()).getModulus().bitLength() < this.bitLength)
        {
            System.out.println("FAILED: key size is <" + this.bitLength + " bit, exactly "
                            + ((NaccacheSternKeyParameters)pair.getPublic()).getModulus().bitLength() + " bit");
            System.err.println("failed key generation (" + this.bitLength + ") length test");
        }

        pubParameters = (NaccacheSternKeyParameters) pair.getPublic();
        
        // Initialize Engines with KeyPair

        cryptEng.init(true, pair.getPublic());

        decryptEng.init(false, pair.getPrivate());
    }

    public byte[] encrypt(byte[] input)
    {

        // create work array
        byte[] data = new byte[input.length];
        System.arraycopy(input, 0, data, 0, data.length);

        // Perform encryption like in the paper from Naccache-Stern
        try
        {
        	cryptEng.setCertificate(new BigInteger(this.bitLength, this.rnd));
            data = cryptEng.processData(data);
        }
        catch (InvalidCipherTextException e)
        {
            System.err.println("failed - exception " + e.toString() + "\n" + e.getMessage());
        }

        return data;

    }

    public byte[] decrypt(byte[] input)
    {

        // create work array
        byte[] data = new byte[input.length];
        System.arraycopy(input, 0, data, 0, data.length);

        try
        {
            data = decryptEng.processData(data);
        }
        catch (InvalidCipherTextException e)
        {
            System.err.println("failed - exception " + e.toString() + "\n" + e.getMessage());
        }

        return data;

    }

    public NaccacheSternKeyParameters getPubKey() {
    	return this.pubParameters;
    }
    
    public byte[] getPubKeyAsByteA() {
    	try {
			return NaccacheSternKeySerializationFactory.getSerialized(this.pubParameters);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    	return null;
    }    

//    public  BigInteger getSigma() {
//    	return sigma;
//    }
}
