package Crypto;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;

import org.bouncycastle.crypto.InvalidCipherTextException;

import net.sf.distrib_rsa.cryptosystems.naccacheStern.NaccacheSternEngine;
import net.sf.distrib_rsa.cryptosystems.naccacheStern.NaccacheSternKeyParameters;

public class CryptServerNS {
	
	private NaccacheSternEngine cryptEng;
	private NaccacheSternKeyParameters pubKey;
	private BigInteger sigma;
	private Random rnd;
	
	public CryptServerNS(NaccacheSternKeyParameters pubKey, BigInteger sigma) {
		this.cryptEng = new NaccacheSternEngine(4);
		this.pubKey = pubKey;
		this.cryptEng.init(true, this.pubKey);
		this.sigma = sigma;
		this.rnd = new SecureRandom(new byte[] {(byte)234, (byte)176, (byte)111, (byte)98});
	}
    /**
     * @param <byte[]> first - E(a)
     * @param <byte[]> second - E(b)
     * @return E(a)*E(b) = E(a+b)
     * */
    public byte[] addValues(byte[] first, byte[] second) {
    	try {
			return cryptEng.addCryptedBlocks(first, second);
		} catch (InvalidCipherTextException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    	
    	return null;
    }
    
    /**
     * @param <byte[]> first - E(a)
     * @param <byte[]> second - E(b)
     * @return E(a)*E(-b) = E(a-b)
     * */
    public byte[] subValues(byte[] first, byte[] second) {
    	try {
    		second = this.calcInverse(second);
    		
			return cryptEng.addCryptedBlocks(first, second);
		} catch (InvalidCipherTextException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    	
    	return null;
    }

    /**
     * @param <byte[]> encValue - E(a)
     * @param <byte[]> constant - c
     * @return E(a)^c = E(a*c)
     * */
    public byte[] multiplyValue(byte[] encValue, int constant) {
    	byte[] ret = null, cur = encValue;
    	boolean start = true;
    	int i=0;
    	int orig_constant = constant;
    	
//    	x^k
//    	
//    	while k > 0
//        if k mod 2 == 1
//          res = res * aktpot
//        end-if
//        aktpot = aktpot^2
//        k = k DIV 2 //Ganzzahlige Division (das Ergebnis wird abgerundet)
//      end-while

    	//square-and-multiply adaption into multiply-and-add for a faster public multiplication
    	while(constant > 0) {
    		if(constant % 2 == 1) {
    			if(start) {
    				ret = cur;
    				start = false;
    			} else {
    				ret = this.addValues(ret, cur);
    				i++;
    			}
    		}
    		cur = this.addValues(cur, cur);
    		i++;
    		constant /= 2;
    	}
    	
    	System.out.println("Used " + i + " additions to multiply with " + orig_constant);
    	
    	return ret;
    }
    
    /**
     * @param <byte[]> encValue - E(a)
     * @param <byte[]> constant - c
     * @return E(a)^c = E(a*c)
     * */
    public byte[] multiplyValue(byte[] encValue, BigInteger constant) {
    	byte[] ret = null, cur = encValue;
    	boolean start = true;
    	
    	BigInteger ZERO = BigInteger.valueOf(0);
    	BigInteger i = BigInteger.valueOf(0);
    	BigInteger ONE = BigInteger.valueOf(1);
    	BigInteger TWO = BigInteger.valueOf(2);
    	BigInteger orig_constant = constant;
    	
//    	x^k
//    	
//    	while k > 0
//        if k mod 2 == 1
//          res = res * aktpot
//        end-if
//        aktpot = aktpot^2
//        k = k DIV 2 //Ganzzahlige Division (das Ergebnis wird abgerundet)
//      end-while

    	//square-and-multiply adaption into multiply-and-add for a faster public multiplication
    	while(constant.compareTo(ZERO) == 1) { //as long as constatnt > 0
    		if(constant.mod(TWO).compareTo(ONE) == 0) { //if constant % 2 == 1
    			if(start) {
    				ret = cur;
    				start = false;
    			} else {
    				ret = this.addValues(ret, cur);
    				i = i.add(ONE);
//    				System.out.println("Adding the current value onto the final one.");
    			}
    		}
    		cur = this.addValues(cur, cur);
			i = i.add(ONE);
//			System.out.println("Multiply the current value by two.");
    		constant = constant.divide(TWO);
    	}
    	    	
//    	System.out.println("Used " + i + " additions to multiply with " + orig_constant);

    	return ret;
    }

    public byte[] calcInverse(byte[] value) {
    	byte[] ret=null;
    	BigInteger val = new BigInteger(1, value);
    	
    	val = val.modInverse(this.pubKey.getModulus());
    	
    	ret = this.pubKey.getModulus().toByteArray();
        Arrays.fill(ret, (byte)0);
        System.arraycopy(val.toByteArray(), 0, ret, ret.length - val.toByteArray().length,
        					val.toByteArray().length);

        return ret;
    }
    
    public byte[] encrypt(byte[] input)
    {

        // create work array
        byte[] data = new byte[input.length];
        System.arraycopy(input, 0, data, 0, data.length);

        try
        {
            data = cryptEng.processData(data);
        }
        catch (InvalidCipherTextException e)
        {
            System.err.println("failed - exception " + e.toString() + "\n" + e.getMessage());
        }

        return data;
    }
    
    public BigInteger getRandomWithinSigma() {
    	BigInteger r;
    	do {
    	    r = new BigInteger(this.sigma.bitLength(), this.rnd);
    	} while (r.compareTo(this.sigma) >= 0);
    	
    	return r;
    }
    
    public BigInteger getRandomWithinModulo() {
    	BigInteger r;
    	do {
    	    r = new BigInteger(this.pubKey.getModulus().bitLength(), this.rnd);
    	} while (r.compareTo(this.pubKey.getModulus()) >= 0);
    	
    	return r;
    }

    public BigInteger getSigma() {
    	return this.sigma;
    }
}
