package Crypto;

import java.security.SecureRandom;
import java.util.Random;

public class RandomSource {

	private static final long randomSeedGeneratorSeed = 1689023012;

	private static SecureRandom secureRandomSeedGenerator = new SecureRandom(); 
	private static int secureRandomSeedGeneratorCount = 0;
	private static Random randomSeedGenerator = new Random(randomSeedGeneratorSeed);
	private static int randomSeedGeneratorCount = 0;
	
	Random rnd;
	
	public RandomSource(boolean secure) {
		if(secure)
			this.rnd = new SecureRandom();
		else
			this.rnd = new Random();
	}
	
	public Random getRandom() {
		return this.rnd;
	}
	
	public static final long getNextSeed(boolean secure) {
		if(secure) {
			secureRandomSeedGeneratorCount++;
			return secureRandomSeedGenerator.nextLong();
		}
		else {
			randomSeedGeneratorCount++;
			return randomSeedGenerator.nextLong();
		}
	}
}
