package Helper;
import java.io.StringWriter;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Logger;

public class Timer {

	private final Logger log = Logger.getLogger(getClass().getName());

	public static final String dateFormatTimeDiff = "HH:mm:ss:SSS";

	private long start=0;
	private long stop=0;
	private Vector<Long> timePoints;
	private SimpleDateFormat dateFormat = new SimpleDateFormat(this.dateFormatTimeDiff);
	private String name;
	
	public Timer(String name) {
		this.timePoints = new Vector<Long>();

		this.name = name;
		dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
		this.start = System.currentTimeMillis();
//		log.setUseParentHandlers(false);
	}
	
	public Timer() {
		this("timer_" + (new SecureRandom()).nextInt());
	}

	public void restart() {
		this.start = System.currentTimeMillis();
		this.stop = 0;
		this.timePoints = new Vector<Long>();
	}

	public long getElapsedTimeMillis() {
		long elapsed = 0;
		if(this.stop == 0) {
			elapsed = System.currentTimeMillis() - this.start;
		} else {
			elapsed = this.stop - this.start;
		}
		
		return elapsed;
	}
	
	public long getStartTimeMillis() {
		return this.start;
	}

	public String getElapsedTime() {
		return this.getTime(true, false);
	}

	public void setIntermediate() {
		this.timePoints.add(System.currentTimeMillis());
	}

	public void stop() {
		this.stop = System.currentTimeMillis();
	}
	
	public void stopPrintToLog() {
		this.stopPrintToLog(null);
	}
	
	public void stopPrintToLog(String text) {
		this.stop = System.currentTimeMillis();
		this.printTimesDiffToLog(text);
	}

	public String getTimesDiff() {
		return this.getTime(true, true);
	}
	
	public String getTimesAbsolute() {
		return this.getTime(false, true);
	}

	public String getTime(boolean diffs, boolean intermediaries) {
		StringWriter out = new StringWriter();
		int i=0;
		long elapsed=0;
		
		out.append("Start: " + dateFormat.format(new Date(this.start)) + "\n");
		
		if(intermediaries) {
			for (i=0; i<timePoints.size(); i++) {
				long time = timePoints.get(i);
				
				if(diffs) {
					elapsed = time - this.start;
				} else {
					elapsed = time;
				}
				out.append("Intermediary " + (i+1) + ": " + dateFormat.format(new Date(elapsed)) + "\n");
			}
		}
		
		if(stop > 0) {
			if(diffs) {
				elapsed = this.stop - this.start;
			} else {
				elapsed = this.stop;
			}
			out.append("Finished: " + dateFormat.format(new Date(elapsed)));
		} else {
			long cur = System.currentTimeMillis();
			if(diffs) {
				elapsed = cur - this.start;
			} else {
				elapsed = cur;
			}
			out.append("Up to now: " + dateFormat.format(new Date(elapsed)));
		}
		
		return out.toString();
	}
	
	public void printTimesDiffToLog() {
		this.printTimesDiffToLog(null);
	}

	public void printTimesDiffToLog(String text) {
		if (text == null)
			log.warning(this.getTimesDiff());
		else
			log.warning(text + "\n" + this.getTimesDiff());
	}

	public void printTimesAbsoluteToLog() {
		this.printTimesDiffToLog(null);
	}

	public void printTimesAbsoluteToLog(String text) {
		if (text == null)
			log.warning(this.getTimesAbsolute());
		else
			log.warning(text + "\n" + this.getTimesAbsolute());
	}
}