package Helper;

import java.math.BigInteger;

public class UnitConversion {

	public static final byte[] intToByteA(int in) {
		byte[] ret = new byte[4];
		
		ret[0] = ( byte) (in >>> 24);
		ret[1] = (byte) (in >>> 16);
		ret[2] = (byte) (in >>> 8);
		ret[3] = (byte) (in >>> 0);
				
		return ret;
	}
	
	public static final int byteAToInt(byte[] in) {
		int ret=0;
		
		if(in.length < 4)
			return -1;
		
		ret = (in[0] << 24)
                + ((in[1] & 0xFF) << 16)
                + ((in[2] & 0xFF) << 8)
                + (in[3] & 0xFF);
		
		return ret;
	}
	
	public static final byte[] longToByteA(long in) {
		byte[] ret = new byte[4];
		
		ret[0] = (byte) (in >>> 24);
		ret[1] = (byte) (in >>> 16);
		ret[2] = (byte) (in >>> 8);
		ret[3] = (byte) (in >>> 0);
				
		return ret;
	}
	
	public static final long byteAToLong(byte[] in) {
		int ret=0;
		
		if(in.length < 4)
			return -1;
		
		ret = (in[0] << 24)
                + ((in[1] & 0xFF) << 16)
                + ((in[2] & 0xFF) << 8)
                + (in[3] & 0xFF);
		
		return ret;
	}
	
	public static final byte[] boolToByteA(boolean in) {
	    return new byte[]{(byte)(in ? 0x01 : 0x00)}; // bool -> {1 byte}
	}

	public static final boolean byteAToBool(byte[] in) {
	    boolean ret = false;
	    
	    if(in.length > 0) {
	    	ret = true; 
	    	
	    	if(in[0] == 1)
	    		ret = true;
	    	if(in[0] == 0)
	    		ret = false;
	    }
	    	
	    return ret;
	}

	public static final BigInteger boolToBigInt(boolean in) {
		if(in)
			return BigInteger.ONE;
		else
			return BigInteger.ZERO;
	}

	public static final boolean intToBool(int in) {
		if(in == 0)
			return false;
		else
			return true;
	}

	public static final int boolToInt(boolean in) {
		if(in)
			return 1;
		else
			return 0;
	}


}
