/**
 * 
 */
package net.sf.distrib_rsa;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

/**
 * InputStreamStatistics counts the bytes on a InputStream and gives statistics
 * on the traffic recieved.
 * 
 * @author lippold
 * 
 */
public class InputStreamStatistics extends FilterInputStream {

	private long byteCount = 0;

	private final Date startDate = new Date();

	public InputStreamStatistics(InputStream in) throws IOException {
		super(in);
	}
	
	public int read() throws IOException{
		byteCount++;
		return super.read();
	}
	
	public int read(byte[] b) throws IOException{
		int retval = super.read(b);
		byteCount += retval;
		return retval;
	}
	
	public int read(byte[] b, int off, int len) throws IOException{
		int retval = super.read(b, off, len);
		byteCount += retval;
		return retval;
	}

	public long getByteCount() {
		return byteCount;
	}

	public long getRunningTime() {
		final Date finish = new Date();
		final long runtime = finish.getTime() - startDate.getTime();
		final long seconds = runtime / 1000;
		return seconds;
	}

	public long getBytesPerSecond() {
		return getByteCount() / getRunningTime();
	}

}
