package net.sf.distrib_rsa.cryptosystems.naccacheStern;

import java.math.BigInteger;

import org.bouncycastle.crypto.params.AsymmetricKeyParameter;

/**
 * Public key parameters for NaccacheStern cipher. For details on this cipher,
 * please see
 * 
 * http://www.gemplus.com/smart/rd/publications/pdf/NS98pkcs.pdf
 */
public class NaccacheSternKeyParameters extends AsymmetricKeyParameter {

	/**
	 * @uml.property  name="y"
	 * @uml.associationEnd  
	 */
	protected BigInteger y;

	/**
	 * @uml.property  name="n"
	 */
	private BigInteger n;

	/**
	 * @uml.property  name="sigma"
	 */
	private BigInteger sigma;

	/**
	 * Construct a NaccacheStern public key.
	 * 
	 * @param y
	 *            the public enryption parameter y
	 * @param n
	 *            the public modulus n = p*q
	 * @param sigma
	 *            the public sigma up to which data can be encrypted
	 */
	public NaccacheSternKeyParameters(final BigInteger y, final BigInteger n,
			final BigInteger sigma) {
		this(false, y, n, sigma);
	}

	/**
	 * Construct a NaccacheStern public key.
	 * 
	 * @param privateKey
	 *            should be set to false. For private keys, see
	 *            NaccacheSternPrivateKeyParameters.
	 * @param y
	 *            the public enryption parameter g
	 * @param n
	 *            the public modulus n = p*q
	 * @param sigma
	 *            the public sigma up to which data can be encrypted
	 */
	public NaccacheSternKeyParameters(final boolean privateKey,
			final BigInteger y, final BigInteger n, final BigInteger sigma) {
		super(privateKey);
		this.y = y;
		this.n = n;
		this.sigma = sigma;
	}

	/**
	 * @return  Returns the g.
	 * @uml.property  name="y"
	 */
	public BigInteger getY() {
		return y;
	}

	/**
	 * @return  Returns the lowerSigmaBound.
	 * @uml.property  name="sigma"
	 */
	public BigInteger getSigma() {
		return sigma;
	}

	/**
	 * @return Returns the n.
	 */
	public BigInteger getModulus() {
		return n;
	}

	public String toString() {
		String retval = "";
		retval += "Modulus:.... " + n + "\n";
		retval += "y:.......... " + y + "\n";
		retval += "Sigma:...... " + sigma + "\n";
		return retval;
	}

}
