package net.sf.distrib_rsa.protocols.gilboaSharing;

/**
 * @author lippold Published under the GPLv2 Licence (c) 2006 Georg Lippold
 * 
 */
public interface GilboaProtocol {

	/**
	 * Client -> Server: The client proposes a shared key size (in bits)
	 * 
	 * Server -> Client: The server answers with min(proposal, own), because
	 * security for each party is determined by NCS-KeySize (pre-generated).
	 */
	static final int PREFERRED_SHARED_KEY_SIZE = 1;

	/**
	 * Client -> Server: Start transfer of Benaloh systems.
	 * 
	 * Server -> Client: OK
	 * 
	 */
	static final int START_BENALOH_SETUP = 2;

	/**
	 * Client -> Server
	 * 
	 * The Benaloh System for one prime.
	 */
	static final int BENALOH_SETUP = 3;

	/**
	 * Server -> Client Client -> Server
	 * 
	 * All Benaloh systems have been transferred
	 * 
	 */
	static final int BENALOH_SETUP_FINISHED = 4;

	/**
	 * Server -> Client
	 * 
	 * Not all necessary benaloh systems have been transferred. Aborting.
	 * 
	 */
	static final int BENALOH_SETUP_FAILED = 5;

	/**
	 * Client -> Server: Initiate generation of p and q (both == 0 mod 4)
	 * 
	 * Server -> Client: p and q generated, now client generates p and q (both ==
	 * 3 mod 4).
	 */
	static final int START_CANDIDATE_GENERATION = 6;

	/**
	 * Client -> Server:
	 * 
	 * Server -> Client:
	 * 
	 * Values mod this prime
	 */
	static final int CONVERSION_MOD_PRIME = 7;

	/**
	 * Client -> Server
	 * 
	 * The clients encrypted p mod prime
	 */
	static final int REMOTE_Z1 = 8;

	/**
	 * Client -> Server
	 * 
	 * the clients encrypted q mod prime
	 */
	static final int REMOTE_Z2 = 9;

	/**
	 * Server -> Client
	 * 
	 * (z1^q_server) * (z2^p_server) * (p_server * q_server mod prime)
	 */
	static final int COMPUTED_N_ = 10;

	/**
	 * Client -> Server
	 * 
	 * Indicate that the current sharing of P1, P2, Q1, Q2 is divisible by the
	 * following small prime. Request new sharing modulo that prime.
	 * 
	 */
	static final int N_MOD_PRIME_IS_0 = 11;

	/**
	 * Client -> Server, Server -> Client
	 * 
	 * All small primes for defining p and q are through, p and q will not be
	 * changed any more if the verfication fails, p and q have to be
	 * regenerated.
	 * 
	 * 
	 */
	static final int GENERATION_FINISHED = 12;

	/**
	 * Client -> Server: Client detected that either p or q has is not equal to
	 * 3 mod 4. Restarts generation.
	 */
	static final int NOT_3_MOD_4 = 15;

	/**
	 * Starts the verification of the candidates, p and q cannot be changed any
	 * more. If verification fails (i.e. for one prime the client detects that
	 * n=p*q mod prime = 0), the process is restarted at
	 * START_CANDIDATE_GENERATION.
	 * 
	 */
	static final int START_VERIFICATION = 16;

	/**
	 * Indicates that the verification has completed successfully.
	 */
	static final int VERIFICATION_FINISHED = 17;

	/**
	 * Indicated that the verification failed because for one prime n mod prime =
	 * 0. Other possibility: Server detects that not all necessary primes were
	 * verified.
	 * 
	 */
	static final int VERIFICATION_FAILED = 18;

	/**
	 * Client -> Server: Generated RSA N from remainders of the protocol
	 * 
	 * Server -> Client: N stored
	 */
	static final int NEW_N = 19;

	/**
	 * Server -> Client: Server detected that not all necessary primes for key
	 * generation were used.
	 */
	static final int N_FAILED = 20;

	/**
	 * Client -> Server
	 * 
	 * Server -> Client
	 * 
	 * Synchronization point for biprimality test
	 */
	static final int PREPARE_BIPRIME_TEST = 21;

	/**
	 * Both parties agree on the certainty with wich n shall be the product of
	 * two primes. Here, the larger of the two proposed values is used.
	 */
	static final int PRIME_CERTAINTY = 22;

	/**
	 * During BiPrimality test, the witness used follows right after this token
	 */
	static final int WITNESS = 23;

	/**
	 * During BiPrimality test, the witness in the twisted group follows right
	 * after this token
	 */
	static final int TW_WITNESS = 24;

	/**
	 * Both parties declare that n is verified for the witness and the witnes in
	 * the twisted group.
	 */
	static final int N_VERIFIED = 25;

	/**
	 * Starts the rsa key generation for the shared rsa n.
	 */
	static final int START_RSA_KEY_GENERATION = 26;

	static final int SHA1_DIGEST = 27;

	static final int BIPRIME_TEST = 28;

}
