/**
 * 
 */
package net.sf.distrib_rsa.ui;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

import javax.swing.JOptionPane;

import net.sf.distrib_rsa.EnvironmentSetup;


/**
 * @author lippold
 * 
 */
public class SaveSettings {

	public static void save(final Properties prop)
			throws FileNotFoundException, IOException {
		final int yesNo = JOptionPane.showConfirmDialog(
				StandardDialogs.getAppFrame(),
				"Do you want to save your settings?", "Save settings",
				JOptionPane.YES_NO_OPTION);
		if (yesNo == JOptionPane.YES_OPTION) {
			final String[] propEndings = { "properties" };
			final File saveTo = StandardDialogs.saveFileDialog(propEndings,
					"Save settings to", "Property File (.properties)");
			String comment = "";
			comment += "Property file for " + EnvironmentSetup.class + "\n";
			prop.store(new FileOutputStream(saveTo), comment);
		}
	}
}
